<?php

namespace Modules\MpesaIntegration\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\MpesaIntegration\Models\MpesaCredential;
use Iankumu\Mpesa\Facades\Mpesa;

class MpesaController extends Controller
{
    public function settings()
    {
        $business_id = request()->session()->get('user.business_id');
        $credentials = MpesaCredential::where('business_id', $business_id)->first();
        return view('mpesaintegration::settings', compact('credentials'));
    }

    public function storeSettings(Request $request)
    {
        $business_id = request()->session()->get('user.business_id');
        MpesaCredential::updateOrCreate(
            ['business_id' => $business_id],
            $request->only(['consumer_key', 'consumer_secret', 'shortcode', 'passkey', 'initiator_name', 'initiator_password'])
        );
        return back()->with('status', 'M-PESA settings saved.');
    }

    private function getCredentials()
    {
        $business_id = request()->session()->get('user.business_id');
        return MpesaCredential::where('business_id', $business_id)->firstOrFail();
    }

    private function configureMpesa($credentials)
    {
        config([
            'mpesa.consumer_key' => $credentials->consumer_key,
            'mpesa.consumer_secret' => $credentials->consumer_secret,
            'mpesa.short_code' => $credentials->shortcode,
            'mpesa.passkey' => $credentials->passkey,
            'mpesa.initiator_name' => $credentials->initiator_name,
            'mpesa.initiator_password' => $credentials->initiator_password,
        ]);
    }

    public function stkPush(Request $request)
    {
        $credentials = $this->getCredentials();
        $this->configureMpesa($credentials);

        $response = Mpesa::stkPush([
            'amount' => $request->amount,
            'phone' => $request->phone,
            'reference' => 'POS Payment',
            'description' => 'POS Sale Payment'
        ]);

        return response()->json($response);
    }

    public function c2bRegisterUrls()
    {
        $credentials = $this->getCredentials();
        $this->configureMpesa($credentials);

        $response = Mpesa::registerUrls([
            'confirmation_url' => url('/mpesa/c2b/confirmation'),
            'validation_url' => url('/mpesa/c2b/validation'),
        ]);

        return response()->json($response);
    }

    public function b2c(Request $request)
    {
        $credentials = $this->getCredentials();
        $this->configureMpesa($credentials);

        $response = Mpesa::b2c([
            'amount' => $request->amount,
            'phone' => $request->phone,
            'remarks' => 'POS Refund',
            'occassion' => 'Refund'
        ]);

        return response()->json($response);
    }

    public function c2bConfirmation(Request $request)
    {
        \Log::info('C2B Confirmation:', $request->all());
        return response('Success', 200);
    }

    public function c2bValidation(Request $request)
    {
        \Log::info('C2B Validation:', $request->all());
        return response('Validated', 200);
    }

    public function callback(Request $request)
    {
        \Log::info('M-PESA Callback:', $request->all());
        return response()->json(['success' => true]);
    }
}