<?php

use Illuminate\Support\Facades\Route;
use Modules\MpesaIntegration\Controllers\MpesaController;

Route::middleware(['web', 'auth', 'SetSessionData'])->prefix('mpesa')->group(function () {
    Route::get('/settings', [MpesaController::class, 'settings'])->name('mpesa.settings');
    Route::post('/settings', [MpesaController::class, 'storeSettings']);
    Route::post('/stk-push', [MpesaController::class, 'stkPush'])->name('mpesa.stk');
    Route::post('/b2c', [MpesaController::class, 'b2c'])->name('mpesa.b2c');
    Route::get('/c2b/register-urls', [MpesaController::class, 'c2bRegisterUrls'])->name('mpesa.c2b.register');
    Route::post('/callback', [MpesaController::class, 'callback'])->name('mpesa.callback');
    Route::post('/c2b/confirmation', [MpesaController::class, 'c2bConfirmation']);
    Route::post('/c2b/validation', [MpesaController::class, 'c2bValidation']);
});