// ✅ Place this in a JS file like public/js/mpesa.js or inline in the POS view
$(document).ready(function () {
    // Trigger when M-PESA is selected
    $(document).on('change', '.payment_types_dropdown', function () {
        let method = $(this).val();
        let row_index = $(this).closest('.payment_row').find('.payment_row_index').val();

        if (method === 'mpesa') {
            // Inject phone input if not present
            let phoneInput = $(this).closest('.payment_row').find('.mpesa-phone-container');
            if (phoneInput.length === 0) {
                let html = `
                <div class="form-group mpesa-phone-container">
                    <label for="mpesa_phone_${row_index}">Enter M-PESA Phone Number:</label>
                    <input type="text" class="form-control mpesa-phone" name="payment[${row_index}][mpesa_number]" id="mpesa_phone_${row_index}" placeholder="e.g. 2547XXXXXXXX" required>
                    <small class="text-muted">Safaricom line only (used for STK Push)</small>
                </div>`;
                $(this).closest('.payment_row').find('.form-group').last().after(html);
            }
        } else {
            // Remove phone field if another method is selected
            $(this).closest('.payment_row').find('.mpesa-phone-container').remove();
        }
    });

    // On Finalize Payment (send STK Push via AJAX)
    $('#pos-save').on('click', function (e) {
        let selectedMpesa = $('.payment_types_dropdown option:selected[value="mpesa"]');
        if (selectedMpesa.length > 0) {
            e.preventDefault(); // prevent form

            let form = $(this).closest('form');
            let phone = form.find('.mpesa-phone').val();
            let amount = form.find('input.payment-amount').val();

            if (!phone || !amount) {
                alert('Enter valid M-PESA number and amount');
                return;
            }

            $.ajax({
                url: '/mpesa/stk-push',
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    phone: phone,
                    amount: amount
                },
                success: function (response) {
                    alert('M-PESA STK Push sent. Complete payment on your phone.');
                    // Optionally auto-submit form or wait for callback
                    form.submit();
                },
                error: function (xhr) {
                    alert('M-PESA STK failed. ' + xhr.responseText);
                }
            });
        }
    });
});
