<?php $request = app('Illuminate\Http\Request'); ?>

<?php
    $pos_layout = $request->segment(1) == 'pos' &&
                  ($request->segment(2) == 'create' || $request->segment(3) == 'edit' || $request->segment(2) == 'payment');
    $whitelist = ['127.0.0.1', '::1'];
?>

<!DOCTYPE html>
<html class="tw-bg-white tw-scroll-smooth" lang="<?php echo e(app()->getLocale(), false); ?>"
      dir="<?php echo e(in_array(session()->get('user.language', config('app.locale')), config('constants.langs_rtl')) ? 'rtl' : 'ltr', false); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token(), false); ?>">

    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e(Session::get('business.name'), false); ?></title>

    <?php echo $__env->make('layouts.partials.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.extracss', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('css'); ?>

    <!-- PWA Meta -->
    <link rel="icon" type="image/png" href="/public/favicon-96x96.png" sizes="96x96" />
    <link rel="icon" type="image/svg+xml" href="/public/favicon.svg" />
    <link rel="shortcut icon" href="/public/favicon.ico" />
    <link rel="apple-touch-icon" sizes="180x180" href="/public/apple-touch-icon.png" />
    <link rel="manifest" href="/public/site.webmanifest" />
    <link rel="manifest" href="/manifest.json">
    <meta name="theme-color" content="#0a3d62">
    <link rel="apple-touch-icon" href="/pwa-icons/icon-192.png">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="mobile-web-app-capable" content="yes">
</head>

<body class="tw-font-sans tw-antialiased tw-text-gray-900 tw-bg-gray-100 <?php if($pos_layout): ?> hold-transition lockscreen <?php else: ?> hold-transition skin-<?php echo e(session('business.theme_color', 'blue-light'), false); ?> sidebar-mini <?php endif; ?>">

    <button id="installBtn" style="display: none; position: fixed; bottom: 20px; right: 20px; z-index: 9999;">Install App</button>

    <div class="tw-flex thetop">
        <script>
            if (localStorage.getItem("upos_sidebar_collapse") == 'true') {
                document.body.classList.add("sidebar-collapse");
            }
        </script>

        <?php if(!$pos_layout && $request->segment(1) != 'customer-display'): ?>
            <?php echo $__env->make('layouts.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if(in_array($_SERVER['REMOTE_ADDR'], $whitelist)): ?>
            <input type="hidden" id="__is_localhost" value="true">
        <?php endif; ?>

        <!-- Currency hidden fields -->
        <input type="hidden" id="__code" value="<?php echo e(session('currency')['code'], false); ?>">
        <input type="hidden" id="__symbol" value="<?php echo e(session('currency')['symbol'], false); ?>">
        <input type="hidden" id="__thousand" value="<?php echo e(session('currency')['thousand_separator'], false); ?>">
        <input type="hidden" id="__decimal" value="<?php echo e(session('currency')['decimal_separator'], false); ?>">
        <input type="hidden" id="__symbol_placement" value="<?php echo e(session('business.currency_symbol_placement'), false); ?>">
        <input type="hidden" id="__precision" value="<?php echo e(session('business.currency_precision', 2), false); ?>">
        <input type="hidden" id="__quantity_precision" value="<?php echo e(session('business.quantity_precision', 2), false); ?>">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_export_buttons')): ?>
            <input type="hidden" id="view_export_buttons">
        <?php endif; ?>
        <?php if(isMobile()): ?>
            <input type="hidden" id="__is_mobile">
        <?php endif; ?>
        <?php if(session('status')): ?>
            <input type="hidden" id="status_span" data-status="<?php echo e(session('status.success'), false); ?>"
                data-msg="<?php echo e(session('status.msg'), false); ?>">
        <?php endif; ?>

        <main class="tw-flex tw-flex-col tw-flex-1 tw-h-full tw-min-w-0 tw-bg-gray-100">
            <?php if($request->segment(1) != 'customer-display' && !$pos_layout): ?>
                <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php elseif($request->segment(1) != 'customer-display'): ?>
                <?php echo $__env->make('layouts.partials.header-pos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <div id="app">
                <?php echo $__env->yieldContent('vue'); ?>
            </div>

            <div class="tw-flex-1 tw-overflow-y-auto tw-h-screen" id="scrollable-container">
                <?php echo $__env->yieldContent('content'); ?>
                <?php if(!$pos_layout): ?>
                    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php else: ?>
                    <?php echo $__env->make('layouts.partials.footer_pos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </div>

            <div class='scrolltop no-print'>
                <div class='scroll icon'><i class="fas fa-angle-up"></i></div>
            </div>

            <?php if(config('constants.iraqi_selling_price_adjustment')): ?>
                <input type="hidden" id="iraqi_selling_price_adjustment">
            <?php endif; ?>

            <section class="invoice print_section" id="receipt_section"></section>
        </main>

        <?php echo $__env->make('home.todays_profit_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <audio id="success-audio">
            <source src="<?php echo e(asset('/audio/success.ogg?v=' . $asset_v), false); ?>" type="audio/ogg">
            <source src="<?php echo e(asset('/audio/success.mp3?v=' . $asset_v), false); ?>" type="audio/mpeg">
        </audio>
        <audio id="error-audio">
            <source src="<?php echo e(asset('/audio/error.ogg?v=' . $asset_v), false); ?>" type="audio/ogg">
            <source src="<?php echo e(asset('/audio/error.mp3?v=' . $asset_v), false); ?>" type="audio/mpeg">
        </audio>
        <audio id="warning-audio">
            <source src="<?php echo e(asset('/audio/warning.ogg?v=' . $asset_v), false); ?>" type="audio/ogg">
            <source src="<?php echo e(asset('/audio/warning.mp3?v=' . $asset_v), false); ?>" type="audio/mpeg">
        </audio>

        <?php if(!empty($__additional_html)): ?>
            <?php echo $__additional_html; ?>

        <?php endif; ?>

        <?php echo $__env->make('layouts.partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="modal fade view_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

        <?php if(!empty($__additional_views) && is_array($__additional_views)): ?>
            <?php $__currentLoopData = $__additional_views; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $additional_view): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if ($__env->exists($additional_view)) echo $__env->make($additional_view, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <div class="overlay tw-hidden"></div>

        <!-- PWA service worker -->
        <script>
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('/service-worker.js')
                    .then(function(reg) {
                        console.log("Service Worker Registered!", reg);
                    }).catch(function(err) {
                        console.log("Service Worker Failed:", err);
                    });
            }

            let deferredPrompt;
            const installBtn = document.getElementById('installBtn');
            window.addEventListener('beforeinstallprompt', (e) => {
                e.preventDefault();
                deferredPrompt = e;
                installBtn.style.display = 'block';

                installBtn.addEventListener('click', () => {
                    deferredPrompt.prompt();
                    deferredPrompt.userChoice.then(choiceResult => {
                        if (choiceResult.outcome === 'accepted') {
                            console.log('App installed');
                        }
                        deferredPrompt = null;
                    });
                });
            });
        </script>
    </div>

    <style>
        @media print {
            #scrollable-container {
                overflow: visible !important;
                height: auto !important;
            }
        }

        .small-view-side-active {
            display: grid !important;
            z-index: 1000;
            position: absolute;
        }

        .overlay {
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.8);
            position: fixed;
            top: 0;
            left: 0;
            display: none;
            z-index: 20;
        }

        .tw-dw-btn.tw-dw-btn-xs.tw-dw-btn-outline {
            width: max-content;
            margin: 2px;
        }

        #scrollable-container {
            position: relative;
        }
    </style>
</body>
</html>
<?php /**PATH /home/ygnbmjdo/galaxypos/resources/views/layouts/app.blade.php ENDPATH**/ ?>